% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program ROCstd.m
function ROCstd = ROCstd(Srating0, Nrating0)

% reconstruct single trial data (sorted by rating)
sorted_S_trials = [1*ones(Srating0(1),1)
    2*ones(Srating0(2),1)
    3*ones(Srating0(3),1) 
    4*ones(Srating0(4),1) 
    5*ones(Srating0(5),1) 
    6*ones(Srating0(6),1)];

sorted_N_trials = [1*ones(Nrating0(1),1)
    2*ones(Nrating0(2),1)
    3*ones(Nrating0(3),1) 
    4*ones(Nrating0(4),1) 
    5*ones(Nrating0(5),1) 
    6*ones(Nrating0(6),1)];
    
ROC0 = [];
for i=1:1000
    resampled_S_trials=[];
    resampled_N_trials=[];
    for j=1:150   % sample 300 trials from the sorted 
                  % single trial data with replacement
        index1 = floor(150*rand(1))+1;
        index2 = floor(150*rand(1))+1;
        resampled_S_trials = [resampled_S_trials; ...
             sorted_S_trials(index1)];
        resampled_N_trials = [resampled_N_trials; ...
             sorted_N_trials(index1)];
    end

    Srating = [];
    Nrating = [];
    for j=1:6     % compute Srating and Nrating from the
                  % resampled data
        Srating = [Srating; ...
              length(find(resampled_S_trials ==j))];
        Nrating = [Nrating; ...
              length(find(resampled_N_trials ==j))];
    end
    Srating(Srating==0)=1;
    Nrating(Nrating==0)=1;
    
    ROC = fittingROC1(Srating, Nrating);
    ROC0=[ROC0; ROC];
end
    
ROCstd=std(ROC0);
